/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.blocks.Weatherable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public interface PatchSpreader<T extends Enum<?>> {
    public Class<T> getType();

    default public boolean getWantedWeatheringState(boolean hasTicked, class_2338 pos, class_1937 level, int maxRecursion) {
        Random posRandom = new Random(class_3532.method_15389((class_2382)pos));
        double v = this.getUnWeatherableChance(level, pos);
        Map<class_2350, Susceptibility> directions = this.getInfluenceForDirections(posRandom, pos, level);
        ArrayList<WeatheringAgent> weatheringAgents = new ArrayList<WeatheringAgent>();
        boolean needsAir = this.needsAirToSpread(level, pos);
        boolean hasAir = false;
        boolean shouldAlwaysWeather = false;
        for (Map.Entry<class_2350, Susceptibility> e : directions.entrySet()) {
            class_2338 facingPos = pos.method_10093(e.getKey());
            class_2680 facingState = level.method_8320(facingPos);
            if (!hasAir && needsAir) {
                hasAir = !facingState.method_26212((class_1922)level, pos);
            }
            Pair<WeatheringAgent, Boolean> pair = this.getBlockWeatheringEffect(e.getValue(), facingState, level, facingPos, maxRecursion);
            weatheringAgents.add((WeatheringAgent)((Object)pair.getFirst()));
            if (!((Boolean)pair.getSecond()).booleanValue()) continue;
            shouldAlwaysWeather = true;
            needsAir = false;
        }
        if (needsAir && !hasAir) {
            return false;
        }
        if (hasTicked && (double)posRandom.nextFloat() < this.getUnWeatherableChance(level, pos)) {
            return false;
        }
        boolean oneSuccess = false;
        for (WeatheringAgent w : weatheringAgents) {
            if (w == WeatheringAgent.PREVENT_WEATHERING) {
                return false;
            }
            if (w != WeatheringAgent.WEATHER) continue;
            oneSuccess = true;
        }
        return oneSuccess;
    }

    default public boolean getWantedWeatheringState(boolean hasTicked, class_2338 pos, class_1937 level) {
        return this.getWantedWeatheringState(hasTicked, pos, level, 2);
    }

    @Deprecated
    default public Map<class_2350, Susceptibility> getInfluenceForDirectionsOld(class_2338 pos, class_1937 level) {
        Random posRandom = new Random(class_3532.method_15389((class_2382)pos));
        HashMap<class_2350, Susceptibility> directions = new HashMap<class_2350, Susceptibility>();
        double directionChance = this.getInterestForDirection(level, pos);
        double highInterestChange = this.getDisjointGrowthChance(level, pos);
        for (class_2350 d : class_2350.values()) {
            if (!((double)posRandom.nextFloat() < directionChance)) continue;
            Susceptibility in = (double)posRandom.nextFloat() < highInterestChange ? Susceptibility.HIGH : Susceptibility.MEDIUM;
            directions.put(d, in);
        }
        return directions;
    }

    default public Map<class_2350, Susceptibility> getInfluenceForDirections(Random posRandom, class_2338 pos, class_1937 level) {
        HashMap<class_2350, Susceptibility> directions = new HashMap<class_2350, Susceptibility>();
        double directionChance = this.getInterestForDirection(level, pos);
        double highInterestChance = this.getDisjointGrowthChance(level, pos);
        int wantedDirs = this.getDirectionCount(posRandom, (float)directionChance);
        ArrayList<class_2350> dirs = new ArrayList<class_2350>(List.of(class_2350.values()));
        Collections.shuffle(dirs, posRandom);
        for (int i = 0; i < dirs.size(); ++i) {
            Susceptibility sus = i < wantedDirs ? ((double)posRandom.nextFloat() < highInterestChance ? Susceptibility.HIGH : Susceptibility.MEDIUM) : Susceptibility.LOW;
            directions.put((class_2350)dirs.get(i), sus);
        }
        return directions;
    }

    default public int getDirectionCount(Random random, float a) {
        int n = 6;
        float[] values = new float[7];
        for (int x = 0; x <= 6; ++x) {
            values[x] = -0.023809524f * ((float)x * (12.0f * a - 2.0f * a - 12.0f + 1.0f) + (float)(x * x) * (1.0f - 2.0f * a) + (2.0f * a * 6.0f - 12.0f));
        }
        float r = random.nextFloat();
        for (int i = 0; i < values.length; ++i) {
            if (!(r < values[i])) continue;
            return i;
        }
        return 0;
    }

    public double getInterestForDirection(class_1937 var1, class_2338 var2);

    public double getDisjointGrowthChance(class_1937 var1, class_2338 var2);

    default public Pair<WeatheringAgent, Boolean> getBlockWeatheringEffect(Susceptibility sus, class_2680 state, class_1937 level, class_2338 pos, int maxRecursion) {
        WeatheringAgent effect = WeatheringAgent.NONE;
        boolean alwaysWeather = false;
        if (sus.value >= Susceptibility.HIGH.value) {
            effect = this.getLowInfluenceWeatheringEffect(state, level, pos, maxRecursion);
        }
        if (effect == WeatheringAgent.NONE && sus.value >= Susceptibility.MEDIUM.value) {
            effect = this.getWeatheringEffect(state, level, pos);
        }
        if (effect == WeatheringAgent.NONE && sus.value >= Susceptibility.LOW.value && (effect = this.getHighInfluenceWeatheringEffect(state, level, pos)) == WeatheringAgent.WEATHER) {
            alwaysWeather = true;
        }
        return Pair.of((Object)((Object)effect), (Object)alwaysWeather);
    }

    default public WeatheringAgent getHighInfluenceWeatheringEffect(class_2680 state, class_1937 level, class_2338 pos) {
        return WeatheringAgent.NONE;
    }

    default public WeatheringAgent getLowInfluenceWeatheringEffect(class_2680 state, class_1937 level, class_2338 pos, int maxRecursion) {
        PatchSpreader p;
        Weatherable w;
        class_2248 b = state.method_26204();
        if (maxRecursion > 0 && b instanceof Weatherable && (w = (Weatherable)b).isWeathering(state) && (p = (PatchSpreader)w.getPatchSpreader(this.getType()).orElse(null)) != null && p.getWantedWeatheringState(false, pos, level, maxRecursion - 1)) {
            return WeatheringAgent.WEATHER;
        }
        return WeatheringAgent.NONE;
    }

    public WeatheringAgent getWeatheringEffect(class_2680 var1, class_1937 var2, class_2338 var3);

    public double getUnWeatherableChance(class_1937 var1, class_2338 var2);

    default public boolean needsAirToSpread(class_1937 level, class_2338 pos) {
        return false;
    }

    public static enum Susceptibility {
        LOW(1),
        MEDIUM(2),
        HIGH(3);

        private final int value;

        private Susceptibility(int effect) {
            this.value = effect;
        }
    }

    public static enum WeatheringAgent {
        NONE,
        WEATHER,
        PREVENT_WEATHERING;

    }
}

